% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate-edge-prediction.R
\name{validateEdgePrediction}
\alias{validateEdgePrediction}
\title{Validate and compare edge prediction methods.}
\usage{
validateEdgePrediction(imputation, refer_community, clustering_args)
}
\arguments{
\item{imputation}{A list or a matrix containing the results of imputation method (s).}

\item{refer_community}{An igraph community object obtained through \code{\link{findCluster}} using a given method.}

\item{clustering_args}{A list indicating the clustering arguments values used in \code{\link{findCluster}} for a given method. This list is retrievable from the output of \code{\link{findCluster}}.}
}
\value{
A list containing the following indices: Jaccard similarity, Dice similarity coefficient, Rand index, Minkowski (inversed), and Fowlkes-Mallows index. The higher value indicates the greater similarity between the imputed dataset and the benchmark.
}
\description{
This function compares the imputation approaches for predicting edges using the clustering result of a submatrix with non-missing values as a benchmark.  This function performs the same analysis as the \code{findCluster} function on every imputed incidence matrices independently. Then, using different similarity measures, all imputation approaches are compared to each other, revealing how edge prediction methods affects network communities (clusters). The best method should result in a higher degree of similarity (common node membership) to the non-missing submatrix as a benchmark.
}
\examples{
# load part of the beatAML data
beatAML_data <- NIMAA::beatAML[1:10000,]

# convert to incidence matrix
beatAML_incidence_matrix <- el2IncMatrix(beatAML_data)

# do clustering
cls <- findCluster(beatAML_incidence_matrix, part = 1)

# predict the edges by imputation the wights
imputed_beatAML <- predictEdge(beatAML_incidence_matrix)

# validate the edge prediction
validateEdgePrediction(imputation = imputed_beatAML,
refer_community = cls$fast_greedy,
clustering_args = cls$clustering_args
)
}
