% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/el2IncMatrix.R
\name{el2IncMatrix}
\alias{el2IncMatrix}
\title{Convert Edge list to Incidence Matrix}
\usage{
el2IncMatrix(el, index_nominal = c(1, 2), index_numeric = 3, print_skim = TRUE)
}
\arguments{
\item{el}{A dataframe or matrix, edgelist data}

\item{index_nominal}{A vector with two values. The indexes for the nominal
columns (the first value indicating the rows objects and the second value
indicating the column object).}

\item{index_numeric}{An integer, the index for numeric values. (this is value
for selecting the column which contains our numeric values and we change it
to the matrix for missing value investigation and imputation).}

\item{print_skim}{A Boolean value, If \code{TRUE}, then the funtion will
print \code{\link[skimr]{skim}} information in console.}
}
\value{
The incidence matrix
}
\description{
This function will convert edge-list-format data (usually a
dataframe concluding 2/3 columns stand for two parts and possible numerical
relationship) to a matrix (columns and rows stand for two parts, values in
the matrix are the 'relationship')
}
\examples{
# generate a edgelist
el <- data.frame(
  A = c(1, 2, 3, 4, 5, 6),
  B = c("a", "b", "c", "e", "f", "g"),
  m = c(1, 2, 1, 2, 1, 2)
)

# run el2IncMatrix() to convert edgelist to incidence matrix
inc_mat <- el2IncMatrix(el, print_skim = FALSE)
}
\seealso{
\code{\link[tidyr]{pivot_wider}},
\code{\link[tibble]{column_to_rownames}}
}
