% Generated by roxygen2 (4.0.1): do not edit by hand
\name{estimate.memory}
\alias{estimate.memory}
\title{Estimate the memory required for an object.}
\usage{
estimate.memory(dat, integer = FALSE, raw = FALSE, unit = c("gb", "mb",
  "kb", "b"), add.unit = FALSE)
}
\arguments{
\item{dat}{either a vector/matrix/dataframe object, or else up to 10 dimensions of such an
object, or a potential object, i.e; c(nrow,ncol). If entering an object directly,
you can leave out the 'integer' and 'raw' arguments as these will be detected from
the object type. Any set of dimensions >10 will be assumed to be a vector, so
if you have such an object, better to submit the total product [base::prod()].}

\item{integer}{if the object or potential object is integer or logical type,
set this argument to TRUE, if this is TRUE, the parameter 'RAW' will
be ignored; integer and logical types use 1/2 of the memory of numeric types}

\item{raw}{if the object or potential object is of 'raw' type,
set this argument to TRUE, note that if 'integer' is TRUE, this parameter 'RAW' will
be ignored; raw types use 1/8 of the memory of numeric types}

\item{unit}{the storage units to use for the result, ie, "gb", "mb","kb", "b" for
gigabytes, megabytes, kilobytes, or bytes respectively.}

\item{add.unit}{logical, whether to append the unit being used to the result,
making the result character type instead of numeric.}
}
\value{
returns the minimum memory requirement to store and object of the specified
size, as a numeric scalar, in gigabytes (default) or else using the units specified by 'unit',
and if add.unit = TRUE, then the result will be character type instead of numeric, with
the units appended.
}
\description{
Can enter an existing object or just the dimensions or total length of a proposed object.
The estimate is based on the object being of numeric type. Integers use half the space
of numeric, raw() use 1/8th of the space. Factors and characters can vary, although
factors will always use less than numeric, and character variables may easily use up
to twice as much depending on the length [nchar()] of each element.
}
\examples{
myMatrix <- matrix(rnorm(100),nrow=10)
myVec <- sample(1:1000)
estimate.memory(myMatrix,unit="bytes") # enter a matrix object
estimate.memory(myVec,unit="kb" ,add.unit=TRUE) # enter a vector object
estimate.memory(c(10,10,10,10,10),unit="kb") # 5 dimensional array
estimate.memory(c(10^6,10^4), add.unit=TRUE) # large matrix
estimate.memory(5.4*10^8, add.unit=TRUE)  # entering argument as # total cells, rather than dims
estimate.memory(5.4*10^8, integer=TRUE, add.unit=TRUE)
estimate.memory(5.4*10^8, raw=TRUE, add.unit=TRUE)
estimate.memory(5.4*10^8, TRUE, TRUE, add.unit=TRUE) #  'integer' overrides 'raw'
}
\author{
Nicholas Cooper \email{nick.cooper@cimr.cam.ac.uk}
}

