% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiObjMatch.R
\name{rho_proposition}
\alias{rho_proposition}
\title{Generate penalty coefficient pairs}
\usage{
rho_proposition(
  paircosts.list,
  rho.max.factor = 10,
  rho1old,
  rho2old,
  rho.min = 0.01
)
}
\arguments{
\item{paircosts.list}{a vector of pair-wise distance.}

\item{rho.max.factor}{a numeric value indicating the maximal rho values.}

\item{rho1old}{a vector of numeric values of rho1 used before.}

\item{rho2old}{a vector of numeric values of rho2 used before.}

\item{rho.min}{smallest rho value to consider.}
}
\value{
a vector of pairs of rho values for future search.
}
\description{
An internal helper function used for automatically generating
the set of rho values used for grid search in exploring the Pareto optimal
set of solutions.
}
