% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Transition_Matrix.R
\name{Transition_Matrix}
\alias{Transition_Matrix}
\title{Computes the transition matrix required in the estimation of the GVAR model}
\usage{
Transition_Matrix(
  t_First,
  t_Last,
  Economies,
  type,
  DataConnectedness = NULL,
  DataPath = NULL
)
}
\arguments{
\item{t_First}{Sample starting date (in the format: yyyy).}

\item{t_Last}{Sample ending date (in the format: yyyy).}

\item{Economies}{A character vector containing the names of the economies included in the system.}

\item{type}{A character string indicating the method for computing interdependence. Possible options include:
\itemize{
     \item \code{Time-varying}: Computes time-varying interdependence and returns the weight matrices for each year based on available data (may extrapolate the sample period).
     \item \code{Sample Mean}: Returns a single weight matrix containing the average weights over the entire sample period, suitable for time-invariant interdependence.
     \item A specific year (e.g., "1998", "2005"): Used to compute time-invariant interdependence for the specified year.
}}

\item{DataConnectedness}{Data used to compute the transition matrix. Default is set to NULL.}

\item{DataPath}{Path to the Excel file containing the data (if applicable). The default is linked to the Excel file available in the package.}
}
\value{
matrix or list of matrices
}
\description{
Computes the transition matrix required in the estimation of the GVAR model
}
\details{
If there is missing data for any country of the system for that particularly year,
then the transition matrix will include only NAs.
}
\examples{
data(CM_Trade)

t_First <- "2006"
t_Last <-  "2019"
Economies <- c("China", "Brazil", "Mexico", "Uruguay")
type <- "Sample Mean"
W_mat <- Transition_Matrix(t_First, t_Last, Economies, type, DataConnectedness = TradeFlows)


}
