% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifeTable.R
\name{lifeTable}
\alias{lifeTable}
\alias{lifeTable,mortalityTable-method}
\title{Return the lifetable object (package lifecontingencies) for the cohort life table}
\usage{
lifeTable(object, ...)

\S4method{lifeTable}{mortalityTable}(object, ...)
}
\arguments{
\item{object}{The life table object (class inherited from mortalityTable)}

\item{...}{Parameters to be passed to the \code{deathProbabilities} method
of the life table}
}
\description{
Return the lifetable object (package lifecontingencies) for the cohort life table
}
\section{Methods (by class)}{
\itemize{
\item \code{mortalityTable}: Return the lifetable object (package lifecontingencies)
for the cohort life table
}}

\examples{
library("lifecontingencies")
mortalityTables.load("Austria_Annuities")
lifeTable(AVOe2005R.male, YOB = 2017)
axn(lifeTable(AVOe2005R.male, YOB = 1975), x = 65, i = 0.03)
axn(lifeTable(AVOe2005R.male, YOB = 2017), x = 65, i = 0.03)

}
