% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_LifeTable.R
\name{coale.demeny.ax}
\alias{coale.demeny.ax}
\title{Find ax[1:2] indicators using Coale-Demeny coefficients
Here we adjust the first two values of ax to account for infant mortality more accurately}
\usage{
coale.demeny.ax(x, mx, ax, sex)
}
\arguments{
\item{x}{Vector of ages at the beginning of the age interval.}

\item{mx}{Death rate in age interval [x, x+n).}

\item{ax}{Numeric scalar. Subject-time alive in age-interval for those who 
die in the same interval. If \code{NULL} this will be estimated. A common 
assumption is \code{ax = 0.5}, i.e. the deaths occur in the middle of 
the interval. Default: \code{NULL}.}

\item{sex}{Sex of the population considered here. Default: \code{NULL}. 
This argument affects the first two values in the life table ax column. 
If sex is specified the values are computed based on Coale-Demeny method 
and are slightly different for males than for females. 
Options: \code{NULL, male, female, total}.}
}
\description{
Find ax[1:2] indicators using Coale-Demeny coefficients
Here we adjust the first two values of ax to account for infant mortality more accurately
}
\keyword{internal}
