% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_methods.R
\name{pmd}
\alias{pmd}
\alias{copmd}
\title{Pattern of Mortality Decline Prediction}
\usage{
pmd(
  e0,
  mx0,
  sex = c("male", "female"),
  nx = 5,
  interp.rho = FALSE,
  kranges = c(0, 25),
  keep.lt = FALSE,
  keep.rho = FALSE,
  ...
)

copmd(e0m, e0f, mxm0, mxf0, nx = 5, interp.rho = FALSE, keep.rho = FALSE, ...)
}
\arguments{
\item{e0}{A vector of target life expectancy, one element for each predicted time point.}

\item{mx0}{A vector with starting age-specific mortality rates.}

\item{sex}{Either "male" or "female".}

\item{nx}{Size of age groups. Should be either 5 or 1.}

\item{interp.rho}{Logical controlling if the \eqn{\rho} coefficients should be interpolated 
(\code{TRUE}) or if the raw (binned) version should be used (\code{FALSE}), as stored in 
the dataset \code{\link{PMDrho}}.}

\item{kranges}{A vector of size two, giving the min and max of the \eqn{k} parameter which is 
estimated to match the target \code{e0} using the bisection method.}

\item{keep.lt}{Logical. If \code{TRUE} additional life table columns are kept in the 
resulting object.}

\item{keep.rho}{Logical. If \code{TRUE} the \eqn{\rho} coefficients are included in the resulting object.}

\item{\dots}{Additional arguments passed to the underlying function. For \code{copmd}, in addition to
\code{kranges} and \code{keep.lt}, it can be \code{sexratio.adjust} which is 
a logical controlling if a sex-ratio adjustment should be applied to prevent crossovers 
between male and female mx. In such a case it uses coefficients from the \code{\link{PMDadjcoef}} dataset. 
However, if the argument \code{adjust.with.mxf} is set to \code{TRUE} (in addition to \code{sexratio.adjust}),
the adjustment is done using the 
female mortality rates as the lower constraint for male mortality rates. 
If the argument \code{adjust.sr.if.needed} is set to \code{TRUE}, a sex-ratio adjustment
is performed dynamically, using the sex ratio in the previous time point. 
In such a case, an adjustment in time t is applied only if there was a drop of sex ratio 
below one at time t-1.}

\item{e0m}{A time series of target male life expectancy.}

\item{e0f}{A time series of target female life expectancy.}

\item{mxm0}{A vector with starting age-specific male mortality rates.}

\item{mxf0}{A vector with starting age-specific female mortality rates.}
}
\value{
Function \code{pmd} returns a list with the following elements: a matrix \code{mx}
    with the predicted mortality rates. If \code{keep.lt} is \code{TRUE}, it also 
    contains matrices \code{sr} (survival rates), and life table quantities \code{Lx} and \code{lx}.
    If \code{keep.rho} is \code{TRUE}, it contains a matrix \code{rho} where columns correpond 
    to the values in the \code{e0} vector and rows correspond to age groups.

Function \code{copmd} returns a list with one element for each sex 
    (\code{male} and \code{female}) where each of them is a list as described above.
    In addition if \code{keep.rho} is \code{TRUE}, element \code{rho.sex} 
    gives the sex-dependent (i.e. not averaged) \eqn{\rho_x} coefficient.
}
\description{
Predict age-specific mortality rates using the Pattern of mortality decline (PMD) method (Andreev et al. 2013).
}
\details{
These functions implements the PMD method introduced in Andreev et al. (2013). 
    It assumes that the future decline in age-specific mortality will follow a certain pattern 
    with the increase in life expectancy at birth (e0): 
    \deqn{\log mx(t) = \log mx(t-1) - k(t) \rho_x(t)}
    
    Here, \eqn{\rho_x(t)} is the age-specific pattern of mortality decline between \eqn{t-1}
    and \eqn{t}. Such patterns for each sex and various levels of e0 
    are stored in the dataset \code{\link{PMDrho}}. The \code{pmd} function can be instructed 
    to interpolate between neighboring levels of e0 by setting the argument \code{interp.rho} 
    to \code{TRUE}. The \eqn{k} parameter is estimated to match the e0 level using the bisection 
    method.
    
    Function \code{pmd} evaluates the method for a single sex, while  \code{copmd} does it
    coherently for both sexes. In the latter case, the same \eqn{\rho_x} 
    (namely the average over sex-specific \eqn{\rho_x}) is used 
    for both, male and female.
}
\examples{
data(mxF, e0Fproj, package = "wpp2017")
country <- "Hungary"
# get initial mortality for the current year
mxf <- subset(mxF, name == country)[,"2010-2015"]
names(mxf) <- c(0,1, seq(5, 100, by=5))
# get target e0
e0f <- subset(e0Fproj, name == country)[-(1:2)]
# project into future
pred <- pmd(e0f, mxf, sex = "female")
# plot first projection in black and the remaining ones in grey 
plot(pred$mx[,1], type = "l", log = "y", ylim = range(pred$mx),
    ylab = "female mx", xlab = "Age", main = country)
for(i in 2:ncol(pred$mx)) lines(pred$mx[,i], col = "grey")

}
\references{
Andreev, K., Gu, D., Gerland, P. (2013). Age Patterns of Mortality Improvement by Level of Life Expectancy at Birth with Applications to Mortality Projections. Paper presented at the Annual Meeting
of the Population Association of America, New Orleans, LA. \url{https://paa2013.princeton.edu/papers/132554}.

Gu, D., Pelletier, F., Sawyer, C. (2017). Projecting Age-sex-specific Mortality: A Comparison of the Modified Lee-Carter and Pattern of Mortality Decline Methods, UN Population Division, 
Technical Paper No. 6. New York: United Nations. \url{https://population.un.org/wpp/Publications/Files/WPP2017_TechnicalPaperNo6.pdf}
}
\seealso{
\code{\link{mortcast}}, \code{\link{mortcast.blend}}, \code{\link{PMDrho}}
}
