% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/life_table.R
\name{life.table}
\alias{life.table}
\title{Life Table Function}
\usage{
life.table(
  mx,
  sex = c("male", "female", "total"),
  abridged = TRUE,
  a0rule = c("ak", "cd"),
  radix = 1,
  open.age = 130
)
}
\arguments{
\item{mx}{Vector of age-specific mortality rates nmx. If \code{abridged} is \code{TRUE} (default), 
the elements correspond to 1m0, 4m1, 5m5, 5m10, \dots. 
If \code{abridged} is \code{FALSE}, they correspond to 1m0, 1m1, 1m2, 1m3, \dots.}

\item{sex}{Which sex the mortality rates correspond to.}

\item{abridged}{Is it an abridged life table (\code{TRUE}, default) or not (\code{FALSE}). 
In the former case, the \code{mx} vector is interpreted as corresponding to age groups 0, 1-4, 5-9, 10-14, \dots.
If \code{FALSE}, the \code{mx} vector is interpreted as corresponding to one-year age groups, i.e. 0, 1, 2, 3, \dots.}

\item{a0rule}{Rule for approximation of a0. "ak" (default) uses the Andreev-Kingkade method (Andreev and Kingkade, 2015), "cd" uses the 
Coale-Demeany method.}

\item{radix}{Base of the life table.}

\item{open.age}{Open age group. If smaller than the last age group of \code{mx}, the life table is truncated. 
It does not have any effect if larger than the last age group.}
}
\value{
Data frame with rows corresponding to age groups and the following columns:
   \describe{
      \item{age}{Starting year of the age group.}
      \item{mx}{Age-specific mortality rates as passed into the \code{mx} argument.}
      \item{qx}{Probability of dying between ages x and x+n.}
      \item{lx}{Number of survivors at age x.}
      \item{dx}{Number of deaths between ages x and x+n.}
      \item{Lx}{Person-years lived between ages x and x+n.}
      \item{sx}{Survival rate from age x to x+n. Note that in an abridged life table, sx always refers to 5-year intervals. 
                Here, sx in the first row is the survival from births to the second age group, sx in the second row 
                is the survival from age 0-4 to age 5-9, third row has the survival from 5-9 to 10-14 etc.}
      \item{Tx}{Person-years lived after age x.}
      \item{ex}{Life expectancy at age x.}
      \item{ax}{Average person-years lived in the interval by those dying in the interval. For young ages, 
                it follows Preston et al. (2001), Table 3.3 on page 48. If \code{a0rule} is "ak" (default) 
                the Andreev-Kingkade method is used for a0. 
                For compatibility with computations done at the UN, we set ax for ages 5 and 10 in the abridged version
                to 2.5. For an unabridged life table, ax is set to 0.5 for all but first and last age groups.}
}
}
\description{
Function for obtaining life table quantities from mortality rates.
}
\details{
Computes a life table corresponding to given mortality rates for either 5- or 1-year age groups. The implementation follows
   Preston et al. (2001).
}
\examples{
data(mxF, e0Fproj, package = "wpp2017")
# get female mortality of Mexico for the current year
country <- "Mexico"
mxf <- subset(mxF, name == country)[,"2010-2015"]
life.table(mxf, sex = "female")

}
\references{
Preston, S.H., Heuveline, P., Guillot, M. (2001). Demography: Measuring and Modeling Population Processes. Oxford: Blackwell Publishers Ltd.
   
   Andreev, E.M. and Kingkade, W.W. (2015). \href{https://www.demographic-research.org/volumes/vol33/13/33-13.pdf}{Average age at death in infancy and infant mortality level: Reconsidering the Coale-Demeny formulas at current levels of low mortality.}
   Demographic Research, 33(13), p.363-390. DOI: 10.4054/DemRes.2015.33.13
}
