% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcaplot3d.r
\name{pcaplot3d}
\alias{pcaplot3d}
\alias{pcaplot3d.symproc}
\alias{pcaplot3d.nosymproc}
\title{visualization of shape variation}
\usage{
pcaplot3d(x, ...)

\method{pcaplot3d}{symproc}(x, pcshow = c(1, 2, 3), mag = 3,
  color = 4, lwd = 1, sym = TRUE, legend = TRUE,
  type = c("spheres", "points"), ...)

\method{pcaplot3d}{nosymproc}(x, pcshow = c(1, 2, 3), mag = 3,
  color = 4, lwd = 1, legend = TRUE, type = c("spheres", "points"),
  ...)
}
\arguments{
\item{x}{a object derived from the function procSym calculated on 3D
coordinates.}

\item{\dots}{Additional parameters which will be passed to the methods.}

\item{pcshow}{a vector containing the PCscores to be visualized.}

\item{mag}{a vector or an integer containing which standard deviation of
which PC has to be visualized.}

\item{color}{color of the 3d points/spheres.}

\item{lwd}{width of the lines representing the shape change.}

\item{sym}{logical: if TRUE the symmetric component of shape is displayed.
Otherwise the asymmetric one.}

\item{legend}{logical: if TRUE a legend explaining the color coding of the PCs is plotted.}

\item{type}{character: for \code{type="spheres"}, the landmarks will be rendered using rgl's \code{spheres3d} function and for \code{type="points"} by  \code{points3d} respectivly.}
}
\value{
returns an invisible array containing the shapes associated with the Principal components selected.
}
\description{
visualization of shape change
}
\details{
visualization of the shape changes explained by Principal components
}
\examples{

\dontrun{
data(boneData)
proc <- procSym(boneLM)
pcaplot3d(proc,pcshow=1:3,mag=-3)#only one PC available
}
}
\seealso{
\code{\link{procSym}}
}
