% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relwarps.r
\name{relWarps}
\alias{relWarps}
\title{calculate relative Warp analysis}
\usage{
relWarps(
  data,
  scale = TRUE,
  CSinit = TRUE,
  alpha = 1,
  tol = 1e-10,
  orp = TRUE,
  pcAlign = TRUE,
  computeBasis = TRUE,
  noalign = FALSE
)
}
\arguments{
\item{data}{Input k x m x n real array, where k is the number of points, m
is the number of dimensions, and n is the sample size.}

\item{scale}{Logical: indicating if scaling is requested}

\item{CSinit}{Logical: if TRUE, all configurations are initially scaled to
Unit Centroid Size.}

\item{alpha}{integer: power of the bending energy matrix. If alpha = 0 then
standard Procrustes PCA is carried out. If alpha = 1 then large scale
differences are emphasized, if alpha = -1 then small scale variations are
emphasised.}

\item{tol}{tolerance for the eigenvalues of the bending energy matrix to be
zero}

\item{orp}{logical: request orthogonal projection into tangent space.}

\item{pcAlign}{logical: if TRUE, the shapes are aligned by the principal axis of the first specimen}

\item{computeBasis}{logical: whether to compute the basis of the resulting vector space (takes a lot of memory and time for configurations with > 1000 coordinates.}

\item{noalign}{logical: if TRUE, data is assumed to be already aligned and alignment and orthogonal projection are skipped.}
}
\value{
\item{bescores }{relative warp scores (PC-scores if \code{alpha = 0})}
\item{uniscores }{uniform scores, NULL if  \code{alpha = 0}}
\item{Var }{non-affine variation explained by each relative warp}
\item{mshape }{sample's conensus shape}
\item{rotated }{Procrustes superimposed data}
\item{bePCs }{vector basis of nonaffine shape variation- relative warps (plain PCs if  \code{alpha = 0})}
\item{uniPCs }{vector basis of affine shape variation - uniform
component. NULL if \code{alpha = 0}}
}
\description{
After Procrustes registration the data is scaled by the bending energy or
its inverse to emphasize global/local differences when exploring a sample's
shape.
}
\examples{

data(boneData)
pop <- name2factor(boneLM,which=3)
rW <- relWarps(boneLM, alpha = -1)
\dontrun{
if (require(car)) {
# plot first 5 relative warps scores grouped by population
spm(rW$bescores[,1:5],group=pop)
# plot uniform component scores grouped by population
spm(rW$uniscores[,1:5],group=pop)
}
##plot non-affine variance associated with each relative warp
barplot(rW$Var[,2], xlab="relative Warps")
## visualize first relative warp +-3 sd of the scores
rw1 <- restoreShapes(as.matrix(c(-3,3)*sd(rW$bescores[,1])),rW$bePCs[,1,drop=FALSE],rW$mshape)
deformGrid3d(rw1[,,1],rw1[,,2],ngrid=5)

## 2D example:
if (require(shapes)) {
data <- bindArr(gorf.dat, gorm.dat, along=3)
sex <- factor(c(rep("fem", dim(gorf.dat)[3]), rep("male",dim(gorm.dat)[3])))
rW <- relWarps(data, alpha = -1)
if (require(car)) {
# plot first 3 relative warps scores grouped by population
spm(rW$bescores[,1:3],group=sex)
# plot uniform component scores grouped by population
spm(rW$uniscores[,1:2],group=sex)
}
##plot non-affine variance associated with each relative warp
barplot(rW$Var[,2], xlab="relative Warps")
## visualize first relative warp +-3 sd of the scores
rw1 <- restoreShapes(as.matrix(c(-3,3)*sd(rW$bescores[,1])),rW$bePCs[,1,drop=FALSE],rW$mshape)
deformGrid2d(rw1[,,1],rw1[,,2],ngrid=10)
}}

}
\references{
Bookstein FL 1989. Principal Warps: Thin-plate splines and the
decomposition of deformations. IEEE Transactions on pattern analysis and
machine intelligence 11.

Bookstein FL, 1991. Morphometric tools for landmark
data. Geometry and biology. Cambridge Univ. Press, Cambridge.

Rohlf FJ, Bookstein FL 2003. Computing the Uniform Component of Shape
Variation. Systematic Biology 52:66-69.
}
\author{
Stefan Schlager
}
