% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSides.r
\name{getSides}
\alias{getSides}
\title{try to identify bilateral landmarks and sort them by side}
\usage{
getSides(x, tol = 3, pcAlign = TRUE, icpiter = 100, ...)
}
\arguments{
\item{x}{matrix containing landmarks (see details)}

\item{tol}{maximal distance allowed between original and mirrored set.}

\item{pcAlign}{logical: if TRUE orginal and mirrored landmarks will be initally aligned by their PC-axes}

\item{icpiter}{integer: number of iterations in ICP alignment.}

\item{...}{more arguments passed to \code{\link{mirror}}.}
}
\value{
returns a list containing
\item{side1}{integer vector containing indices of landmarks on one side}
\item{side2}{integer vector containing indices of landmarks on the other side}
\item{unilat}{integer vector containing indices unilateral landmarks}
}
\description{
try to identify bilateral landmarks and sort them by side
}
\details{
This function mirrors the landmark set and aligns it to the original. Then it tries to find pairs. If you have a sample, run a Procrustes registration first (without scaling to unit centroid size, or you later have to adapt \code{tol} - see examples) and then use the mean as it is usually more symmetrical.
}
\examples{
data(boneData)
proc <- procSym(boneLM,CSinit=FALSE)
mysides <- getSides(proc$mshape)
if (interactive()){
#visualize bilateral landmarks
deformGrid3d(boneLM[mysides$side1,,1],boneLM[mysides$side2,,1])
## visualize unilateral landmarks
rgl::spheres3d(boneLM[mysides$unilat,,1],radius=0.5)
}
}
