% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr-misc.R
\name{color_palettes}
\alias{color_palettes}
\alias{col_summer}
\alias{Palettes}
\alias{col_summer2}
\alias{col_spring}
\alias{col_autumn}
\alias{col_black}
\alias{col_solarized}
\alias{col_gallus}
\alias{col_qual}
\alias{col_heat}
\alias{col_hot}
\alias{col_cold}
\alias{col_sari}
\alias{col_india}
\alias{col_bw}
\alias{col_grey}
\title{Some color palettes}
\usage{
col_summer(n)

col_summer2(n)

col_spring(n)

col_autumn(n)

col_black(n)

col_solarized(n)

col_gallus(n)

col_qual(n)

col_heat(n)

col_hot(n)

col_cold(n)

col_sari(n)

col_india(n)

col_bw(n)

col_grey(n)
}
\arguments{
\item{n}{the number of colors to generate from the color palette}
}
\value{
colors (hexadecimal format)
}
\description{
Colors, colors, colors.
}
\note{
Among available color palettes, \code{col_solarized} is based on Solarized: \url{https://ethanschoonover.com/solarized/};
\code{col_div}, \code{col_qual}, \code{col_heat}, \code{col_cold}
and \code{col_gallus} are based on on ColorBrewer2: \url{https://colorbrewer2.org/}.
}
\examples{

wheel <- function(palette, n=10){
 op <- par(mar=rep(0, 4)) ; on.exit(par(op))
 pie(rep(1, n), col=palette(n), labels=NA, clockwise=TRUE)}

 # Qualitative
 wheel(col_qual)
 wheel(col_solarized)
 wheel(col_summer)
 wheel(col_summer2)
 wheel(col_spring)
 wheel(col_autumn)

 # Divergent
 wheel(col_gallus)
 wheel(col_india)

 # Sequential
 wheel(col_heat)
 wheel(col_hot)
 wheel(col_cold)
 wheel(col_sari)
 wheel(col_bw)
 wheel(col_grey)

 # Black only for pubs
 wheel(col_black)
}
