% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-shapedescriptors.R
\name{coo_elongation}
\alias{coo_elongation}
\title{Calculates the elongation of a shape}
\source{
Rosin PL. 2005. Computing global shape measures.
Handbook of Pattern Recognition and Computer Vision. 177-196.
}
\usage{
coo_elongation(coo)
}
\arguments{
\item{coo}{a \code{matrix} of (x; y) coordinates.}
}
\value{
numeric, the eccentricity of the bounding box
}
\description{
Calculates the elongation of a shape
}
\examples{
coo_elongation(bot[1])
# on Coo
# for speed sake
bot \%>\% slice(1:3) \%>\% coo_elongation
}
\seealso{
Other coo_ descriptors: \code{\link{coo_angle_edge1}},
  \code{\link{coo_angle_edges}},
  \code{\link{coo_angle_tangent}}, \code{\link{coo_area}},
  \code{\link{coo_boundingbox}}, \code{\link{coo_chull}},
  \code{\link{coo_circularity}},
  \code{\link{coo_convexity}},
  \code{\link{coo_eccentricity}}, \code{\link{coo_length}},
  \code{\link{coo_lw}}, \code{\link{coo_rectangularity}},
  \code{\link{coo_rectilinearity}},
  \code{\link{coo_solidity}}, \code{\link{coo_width}}
}
