% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/babel-bridges.R
\name{as_df}
\alias{as_df}
\alias{as_df.Coo}
\alias{as_df.Coe}
\alias{as_df.TraCoe}
\alias{as_df.PCA}
\alias{as_df.LDA}
\title{Converts Momocs objects to data.frames}
\usage{
as_df(x)

\method{as_df}{Coo}(x)

\method{as_df}{Coe}(x)

\method{as_df}{TraCoe}(x)

\method{as_df}{PCA}(x)

\method{as_df}{LDA}(x)
}
\arguments{
\item{x}{an object, typically a Momocs object}
}
\value{
a \code{data.frame}
}
\description{
Used in particular for compatibility with the \code{tidyverse}
}
\examples{
# smaller Out
lite_bot <- bot \%>\% slice(c(1, 2, 21, 22)) \%>\% coo_sample(12)
# Coo object
lite_bot \%>\% as_df \%>\% head
# Coe object
lite_bot \%>\% efourier(2) \%>\% as_df \%>\% head
# PCA object
lite_bot \%>\% efourier(2) \%>\% PCA \%>\% as_df \%>\% head
# LDA object
lite_bot \%>\% efourier(2) \%>\% PCA \%>\% LDA(~type) \%>\% as_df \%>\% head
}
\seealso{
Other bridges functions: \code{\link{bridges}},
  \code{\link{complex}}, \code{\link{export}}
}
