% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-premodern.R
\name{measure}
\alias{measure}
\title{Measures shape descriptors}
\usage{
measure(x, ...)
}
\arguments{
\item{x}{any \code{Coo} object, or a list of shapes, or a shape as a matrix.}

\item{...}{a list of functions. See examples.}
}
\value{
a \link{TraCoe} object, or a raw data.frame
}
\description{
Calculates shape descriptors on Coo and other objects.
Any function that returns a scalar when fed coordinates can be passed
and naturally those of Momocs (pick some there \code{apropos("coo_")}). Functions
without arguments (eg \link{coo_area}) have to be passed without brackets but
functions with arguments (eg \link{d}) have to be passed "entirely". See examples.
}
\examples{
# lets write a custom function
coo_ellipse_area <- function(x){
  prod(coo_lw(x))*pi
}
bm <- measure(bot, coo_area, coo_perim, coo_ellipse_area)
bm
bm$coe

# how to use arguments, eg with the d() function
measure(wings, coo_area, d(1, 3), d(4, 5))

# alternatively
measure(bot$coo, coo_area, coo_perim, coo_ellipse_area)

# and also
measure(bot[1], coo_area, coo_perim, coo_ellipse_area)
}
\seealso{
Other premodern: \code{\link{truss}}
}
