% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr-domesticplotters.R
\name{coo_plot}
\alias{coo_plot}
\alias{coo_plot.default}
\alias{ldk_plot}
\title{Plots a single shape}
\usage{
coo_plot(coo, ...)

\method{coo_plot}{default}(coo, xlim, ylim, border = "#333333", col = NA,
  lwd = 1, lty = 1, points = FALSE, first.point = TRUE,
  centroid = TRUE, xy.axis = TRUE, pch = 1, cex = 0.5, main = NA,
  poly = TRUE, plot.new = TRUE, plot = TRUE, zoom = 1, ...)

ldk_plot(coo, ...)
}
\arguments{
\item{coo}{A \code{list} or a \code{matrix} of coordinates.}

\item{...}{further arguments for use in coo_plot methods. See examples.}

\item{xlim}{If \code{coo_plot} is called and \code{coo} is missing, then a
vector of length 2 specifying the \code{ylim} of the ploting area.}

\item{ylim}{If \code{coo_plot} is called and \code{coo} is missing, then a
vector of length 2 specifying the \code{ylim} of the ploting area.}

\item{border}{A color for the shape border.}

\item{col}{A color to fill the shape polygon.}

\item{lwd}{The \code{lwd} for drawing shapes.}

\item{lty}{The \code{lty} for drawing shapes.}

\item{points}{\code{logical}. Whether to display points. If missing and
number of points is < 100, then points are plotted.}

\item{first.point}{\code{logical} whether to plot or not the first point.}

\item{centroid}{\code{logical}. Whether to display centroid.}

\item{xy.axis}{\code{logical}. Whether to draw the xy axis.}

\item{pch}{The \code{pch} for points.}

\item{cex}{The \code{cex} for points.}

\item{main}{\code{character}. A title for the plot.}

\item{poly}{logical whether to use \link{polygon} and \link{lines} to draw the shape,
or just \link{points}. In other words, whether the shape should be considered as a configuration
of landmarks or not (eg a closed outline).}

\item{plot.new}{\code{logical} whether to plot or not a new frame.}

\item{plot}{logical whether to plot something or just to create an empty plot.}

\item{zoom}{a numeric to take your distances.}
}
\value{
No returned value.
}
\description{
A simple wrapper around \link{plot} for plotting shapes. Widely used in Momocs
in other graphical functions, in methods, etc.
}
\examples{
data(bot)
b <- bot[1]
coo_plot(b)
coo_plot(bot[2], plot.new=FALSE) # equivalent to coo_draw(bot[2])
coo_plot(b, zoom=2)
coo_plot(b, border='blue')
coo_plot(b, first.point=FALSE, centroid=FALSE)
coo_plot(b, points=TRUE, pch=20)
coo_plot(b, xy.axis=FALSE, lwd=2, col='#F2F2F2')
}
\seealso{
Other plotting functions: \code{\link{Ntable}},
  \code{\link{conf_ell}}, \code{\link{coo_arrows}},
  \code{\link{coo_draw}}, \code{\link{coo_listpanel}},
  \code{\link{coo_lolli}}, \code{\link{coo_ruban}},
  \code{\link{ldk_chull}}, \code{\link{ldk_confell}},
  \code{\link{ldk_contour}}, \code{\link{ldk_labels}},
  \code{\link{ldk_links}}, \code{\link{plot_devsegments}}
}
