% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-outopn-calibrate.R
\name{calibrate_reconstructions}
\alias{calibrate_reconstructions}
\title{Calibrate using reconstructed shapes}
\usage{
calibrate_reconstructions(x, method, id, range, baseline1, baseline2)
}
\arguments{
\item{x}{the \code{Coo} object on which to calibrate_reconstructions}

\item{method}{any method from \code{c('efourier', 'rfourier', 'tfourier')}
for \code{Out}, or from \code{c('opoly', 'npoly', 'dfourier')} for \code{Opn}}

\item{id}{the shape on which to perform calibrate_reconstructions}

\item{range}{vector of harmonics on which to perform calibrate_reconstructions}

\item{baseline1}{\eqn{(x; y)} coordinates for the first point of the baseline}

\item{baseline2}{\eqn{(x; y)} coordinates for the second point of the baseline}

\item{...}{only used for the generic}
}
\value{
a ggplot object and the full list of intermediate results. See examples.
}
\description{
Calculate and displays reconstructed shapes using a
range of harmonic number. Compare them visually with the maximal fit.
}
\examples{
data(bot)
calibrate_reconstructions(bot, "efourier", range=1:12)

data(olea)
calibrate_reconstructions(olea, "dfourier")
}
\seealso{
Other calibration: \code{\link{calibrate_deviations}},
  \code{\link{calibrate_harmonicpower}},
  \code{\link{calibrate_r2}}
}
