% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/babel-bridges.R
\name{a2m}
\alias{a2m}
\title{Converts an array of coordinates to a matrix}
\usage{
a2m(a)
}
\arguments{
\item{a}{\code{array} of (x; y) coordinates.}
}
\value{
matrix (see above).
}
\description{
All the individuals (the 3rd dimension of the array) becomes rows, and
columns are (all the) x coordinates and (all the) y coordinates, so that we have
x1, x2, ..., xn, y1, y2, ..., yn columns. Rows and colums are named anyway.
}
\details{
Used in landmarks methods, e.g. for multivariate analysis after a Procrustes alignment.
}
\examples{
data(wings)
a <- l2a(wings$coo)
a
}
\seealso{
\link{m2a} the reverse function.

Other bridges functions: \code{\link{a2l}},
  \code{\link{as_df}}, \code{\link{coo2cpx}},
  \code{\link{cpx2coo}}, \code{\link{d2m}},
  \code{\link{l2a}}, \code{\link{l2m}}, \code{\link{m2a}},
  \code{\link{m2d}}, \code{\link{m2ll}}, \code{\link{m2l}}
}
