% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl-def-Ldk.R
\name{Ldk}
\alias{Ldk}
\title{Builds an Ldk object}
\usage{
Ldk(coo, links = NULL, slidings = NULL, fac = data.frame())
}
\arguments{
\item{coo}{a \code{list} of matrices of (x; y) coordinates,
or an array, an Ldk object.}

\item{links}{(optionnal) a 2-columns \code{matrix} of 'links' between landmarks, mainly for plotting}

\item{slidings}{(optionnal) a 3-columns \code{matrix} defining (if any) sliding landmarks}

\item{fac}{(optionnal) a \code{data.frame} of factors and/or numerics
specifying the grouping structure}
}
\value{
an \code{Ldk} object
}
\description{
In Momocs, \code{Ldk} classes objects are
lists of configurations of \bold{l}an\bold{d}mar\bold{k}s, with optionnal components,
on which generic methods such as plotting methods (e.g. \link{stack})
and specific methods (e.g. todo-Procrustes can be applied.
 \code{Ldk} objects are primarily \code{\link{Coo}} objects.
}
\details{
All the shapes in x must have the same number of landmarks. If you are
trying to make an Ldk object from an Out or an Opn object, try \link{coo_sample} beforehand
to homogeneize the number of coordinates among shapes.

implementation of \code{$slidings} is inspired by \code{geomorph}
}
\examples{
#Methods on Ldk
methods(class=Ldk)
}
