\name{efourier.norm}
\alias{efourier.norm}

\title{
Normalizes harmonic coefficients.
}

\description{
\code{efourier.norm} normalizes Fourier coefficients for rotation, tranlation, size and orientation of the first ellipse.
}

\usage{
efourier.norm(ef, start = FALSE)
}

\arguments{
  \item{ef}{\code{list}. A list containing \eqn{a_n}, \eqn{b_n}, \eqn{c_n} and \eqn{d_n} Fourier coefficients, such as returned by \code{efourier}.}
  \item{start}{\code{logical}. Whether to conserve the position of the first point of the outline.}
}

\details{
See \link{efourier} for the mathematical background of the normalization. Other approaches implemented in SHAPE are possible such as manually editing or using the longest radius. They will be implemented in further Momocs versions.
}

\value{
A list with following components:
  \item{A }{\code{vector} of \code{numeric} \eqn{A_{1->n}} \emph{normalized} harmonic coefficients.}
  \item{B }{\code{vector} of \code{numeric} \eqn{B_{1->n}} \emph{normalized} harmonic coefficients.}
  \item{C }{\code{vector} of \code{numeric} \eqn{C_{1->n}} \emph{normalized} harmonic coefficients.}
  \item{D }{\code{vector} of \code{numeric} \eqn{D_{1->n}} \emph{normalized} harmonic coefficients.}
  \item{size }{Magnitude of the semi-major axis of the first fitting ellipse.}
  \item{theta }{Angle, in radians, between the starting point and the semi-major axis of the first fitting ellipse.}
  \item{psi }{Orientation of the first fitting ellipse.}
  \item{ao }{\code{ao} Harmonic coefficient.}
  \item{co }{\code{co} Harmonic coefficient.}
  \item{lnef }{A \code{list} with A, B, C and D concatenated in a \code{vector} that may be convenient for some uses.}
}

\references{
Claude, J. (2008) \emph{Morphometrics with R}, Use R! series, Springer 316 pp.

Ferson S, Rohlf FJ, Koehn RK. 1985. Measuring shape variation of two-dimensional outlines. \emph{Systematic Biology} \bold{34}: 59-68.
}
\seealso{
\link{efourier} and \link{efourier.i}. Also \link{eFourier} for normalizing harmonic coefficients when calculating it for \code{Coo} objects.
}
\examples{
data(bot)
q <- efourier(bot@coo[[1]], 24)
efourier.i(q) # equivalent to efourier.shape(q$an, q$bn, q$cn, q$dn)
efourier.norm(q)
efourier.shape(nb.h=5, alpha=1.2)
efourier.shape(nb.h=12, alpha=0.9)
}

\keyword{elliptical Fourier analysis}