% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{drop_constants}
\alias{drop_constants}
\title{Drop constant variables from a formula}
\usage{
drop_constants(dat,
               formula,
               sub = NULL)
}
\arguments{
\item{dat}{A \code{data.frame} where rows correspond to observations and columns correspond to variables. Ideally column names should be present.}

\item{formula}{An object of class \code{"\link[stats]{formula}"}: a symbolic description of the model to be fitted. Variables in the \code{formula} not present in the columns of \code{dat} will automatically be discarded. The \code{formula} may include interactions, transformations, or higher order terms: the latter \strong{must} be specified explicitly using the \code{AsIs} operator (\code{\link{I}}).}

\item{sub}{An optional vector specifying a subset of observations to be used in the fitting process.}
}
\value{
The updated formula with constant variables removed.
}
\description{
Drops constant variables from the RHS of a formula taking the data set (\code{dat}), the formula (\code{formula}), and an optional subset vector (\code{sub}) as arguments.
}
\note{
Formulas with and without intercepts are accommodated.
}
\examples{
data(ais)
hema  <- as.matrix(ais[,3:7])
sex   <- ais$sex
BMI   <- ais$BMI

# Set up a no-intercept regression formula with constant column 'sex'
form1 <- as.formula(hema ~ sex + BMI + I(BMI^2) - 1)
sub   <- ais$sex == "male"

# Try fitting a linear model
mod1  <- try(lm(form1, data=ais, subset=sub), silent=TRUE)
inherits(mod1, "try-error") # TRUE

# Remove redundant variables from formula & try again
form2 <- drop_constants(ais, form1, sub)
mod2  <- try(lm(form2, data=ais, subset=sub), silent=TRUE)
inherits(mod2, "try-error") # FALSE
}
\seealso{
\code{\link{drop_levels}}, \code{\link{I}}
}
\author{
Keefe Murphy - <\email{keefe.murphy@mu.ie}>
}
\keyword{utility}
