% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{aitken}
\alias{aitken}
\title{Aitken Acceleration}
\usage{
aitken(loglik)
}
\arguments{
\item{loglik}{A vector of three consecutive log-likelihood values. These three values should be in ascending order, though this is not checked.}
}
\value{
A list with the following named components:
\item{\code{ll}}{The most current estimate for the log-likelihood.}
\item{\code{linf}}{The most current estimate of the final converged maximised log-likelihood.}
\item{\code{a}}{The Aitken acceleration value where typically \code{0 <= a <= 1}. When \code{a < 0}, a numerical issue or bug has occurred; when \code{a > 1}, the algorithm is accelerating and should not be stopped.}
When the \code{"aitken"} method is employed within \code{\link{MoE_clust}} (via \code{\link{MoE_control}}), \code{ll} at convergence gives the log-likelihood achieved by the estimated parameters, while \code{linf} at convergence estimates the log-likelihood that would be achieved after an infinite number of EM/CEM iterations.
}
\description{
Calculates the Aitken acceleration estimate of the final converged maximised log-likelihood under the EM/CEM framework.
}
\details{
The final converged maximised log-likelihood can be used to determine convergence of the EM/CEM algorithm within \code{\link{MoE_clust}}, i.e. by checking whether the absolute difference between the current log-likelihood estimate and the final converged maximised log-likelihood estimate is less than some tolerance.
}
\note{
Within \code{\link{MoE_clust}}, as specified by the \code{stopping} argument of \code{\link{MoE_control}}, \code{"aitken"} is the default method used to assess convergence. The other option monitors the \code{"relative"} change in log-likelihood against some tolerance. See \code{\link{MoE_control}}.
}
\examples{
(a1 <- aitken(-c(449.61534, 442.84221, 436.58999)))
a2  <- aitken(-c(442.84221, 436.58999, 436.58998))
abs(a2$linf - a1$linf) < 1e-05 #FALSE
a3  <- aitken(-c(436.58998, 436.58997, 436.58997))
abs(a3$linf - a2$linf) < 1e-05 #TRUE
(ll <- a3$linf)
(a  <- a3$a)
}
\references{
Boehning, D., Dietz, E., Schaub, R., Schlattmann, P. and Lindsay, B. G. (1994). The distribution of the likelihood ratio for mixtures of densities from the one-parameter exponential family. \emph{Annals of the Institute of Statistical Mathematics}, 46(2): 373-388.
}
\seealso{
\code{\link{MoE_control}}
}
\author{
Keefe Murphy - <\email{keefe.murphy@mu.ie}>
}
\keyword{control}
