% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psych_utils.R
\name{PsychShape}
\alias{PsychShape}
\title{Plot Psychometric Functions given PSE and JND}
\usage{
PsychShape(
  pse = 0,
  jnd = 1,
  p = 0.75,
  x.range = c(NA, NA),
  ps.link = c("probit"),
  ps.type = "solid",
  ps.size = 1,
  ps.color = "black",
  addTo = NULL
)
}
\arguments{
\item{pse, jnd}{point of subjective equivalende (PSE) and just noticeable difference (JND) of the desired psychometric function.}

\item{p}{probability value relative to the JND upper limit. Default is 0.75 (value for 50\% JND).}

\item{x.range}{vector of length two specifying the range of the psychometric function.}

\item{ps.link}{a link function for the binomial family of error distribution.}

\item{ps.type, ps.size, ps.color}{type, size, and color of the plotted line (see \code{"ggplot2-spec"}).}

\item{addTo}{specifies an existing \code{ggplot} object where the new line should be plotted. If no object is given, the function is drawn on a new plot.}
}
\value{
\code{PsychShape} returns a \code{\link[ggplot2]{ggplot}} object.
}
\description{
Plot a psychometric function with known PSE and JND on a new or existing \code{ggplot} object.
}
\details{
\code{PsychShape()} can be used to visualize the predicted results of a
psychophysical experiment or to plot a fitted psychometric function whose
values of pse and jnd are known. Currently only working with probit and logit
link function.
}
\examples{
p <- PsychShape(pse = 0, jnd = 6, x.range = c(-40, 40), ps.color = "gray", ps.size = 3)
p1 <- PsychShape(pse = 6, jnd = 6, x.range = c(-40, 40), ps.col = "black", addTo = p)
p2 <- PsychShape(pse = 6, jnd = 6, x.range = c(-40, 40), ps.col = "red", ps.link = "logit", 
ps.type = "dashed", addTo = NULL)

}
\references{
Moscatelli, A., Mezzetti, M., & Lacquaniti, F. (2012). Modeling psychophysical data 
at the population-level: The generalized linear mixed model. 
Journal of Vision, 12(11):26, 1-17. doi:10.1167/12.11.26

Knoblauch, K., & Maloney, L. T. (2012). Modeling psychophysical data in R (Vol. 32). 
Springer Science & Business Media.
}
\seealso{
\code{\link[stats]{glm}} for for Generalized Linear Models.
\code{\link{PsychFunction}} and \code{\link{PsychDelta}} for estimation of PSE and JND from response data.
\code{\link{PsychPlot}} for plotting a a psychometric function from a GLM.
}
\keyword{GLM}
\keyword{plot}
