% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psych_utils.R
\name{PsychDelta}
\alias{PsychDelta}
\title{PSE/JND for univariable GLM Using Delta Method}
\usage{
PsychDelta(model, alpha = 0.05)
}
\arguments{
\item{model}{the fitted psychometric function. An object of class \code{"glm"}.}

\item{alpha}{significance level of the confidence interval.}
}
\value{
\code{PsychDelta} returns a matrix including Estimate, Standard Error,
Inferior and Superior Confidence Interval of PSE and JND. Confidence Intervals
are computed as: \eqn{Estimate +/- z(1-(\alpha/2)) * Std.Error}.
}
\description{
Estimate the Point of Subjective Equivalence (PSE), the Just Noticeable
Difference (JND) and the related Standard Errors by means of Delta Method.
The method only applies to univariable GLMs (psychometric functions) having
a \emph{probit} link function.
}
\details{
\code{PsychDelta} estimates PSE and JND of a univariable psychometric
function (object of class \code{"glm"}).
}
\note{
The function assumes that the first model coefficient is the intercept
and the second is the slope. The estimate of the JND assumes a \emph{probit}
link function.
}
\examples{
#load simulated data
data(simul_data)
#fit a glm (probit link)
model.glm = glm(formula = cbind(Longer, Total - Longer) ~ X,
family = binomial(link = "probit"), data = simul_data)
PsychDelta(model.glm)

}
\references{
Faraggi, D., Izikson, P., & Reiser, B. (2003). Confidence intervals for the 50 per cent 
response dose. Statistics in medicine, 22(12), 1977-1988. https://doi.org/10.1002/sim.1368

Moscatelli, A., Mezzetti, M., & Lacquaniti, F. (2012). Modeling psychophysical data 
at the population-level: The generalized linear mixed model. 
Journal of Vision, 12(11):26, 1-17. https://doi.org/10.1167/12.11.26
}
\seealso{
\code{\link[stats]{glm}} for for Generalized Linear Models (without
random effects) and \code{\link[lme4]{glmer}} for Generalized Linear Mixed
Models (including random effects). \code{MixDelta} and \code{MixTreatment}
for univarible and multivariable GLMM, respectively (object of class
\code{"\linkS4class{merMod}"}). \code{\link{pseMer}} for bootstrap-based
confidence intervals.
}
\keyword{DeltaMethod}
\keyword{GLM}
\keyword{Univariable}
