% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMlogconcave.R
\name{EMlogconcHD}
\alias{EMlogconcHD}
\title{Clustering with mixtures of log-concave distributions using EM Algorithm
(Multivariate)}
\usage{
EMlogconcHD(x, k, EMnorm, mixiter = 5)
}
\arguments{
\item{x}{Observations. Given as row vectors of x.}

\item{k}{the number of components.}

\item{EMnorm}{Output of EMnorm function}

\item{mixiter}{maximum iteration the algorithm run for EM-algorithm, defualt is 5.}
}
\value{
List of logL:log-likelihood; pis: estimated component proportions;
f:component densities at the observations;Sig: Estimated covariances of the transformed marginals;
fh:logconcave marginal component densities at x; Fh:cdfs of the fh;
}
\description{
Does EM by computing the logconcave MLE for each marginal in
each component in the M-step. Then use the normal copula to
model the correlation structure in each component:
Transform each marginal to a normal using the estimated cdf.
}
\examples{

m=2;
x=mvtnorm::rmvnorm(100,c(0,0),matrix(c(2,1,1,2),nrow=2));x=matrix(x,nrow=100);
x[1:60,]=x[1:60,]+5;
EMnorm = EMnormal(x,m);
\donttest{EMlogc = EMlogconcHD(x,m,EMnorm,mixiter=1);}


}
