% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmmNames.R
\name{kmmNames}
\alias{kmmNames}
\alias{kmmValidModelNames}
\alias{kmmValidKernelNames}
\title{Create a vector of Kernel mixture model (KMM) names.}
\usage{
kmmNames(prop = "all", sdBetweenCluster = "all")

kmmValidModelNames(names)

kmmValidKernelNames(names)
}
\arguments{
\item{prop}{A character string equal to "equal", "free" or "all". Default is "all".}

\item{sdBetweenCluster}{A character string equal to "equal", "free" or "all". Default is "all".}

\item{names}{a vector of character with the names to check}
}
\value{
A vector of character with the model names.

TRUE if the names in the vector names are valid, FALSE otherwise.
}
\description{
In a Kernel mixture model, sssumptions on the proportions
and standard deviations give rise to 4 models:
\enumerate{
 \item {Proportions can be equal or free.}
 \item {Standard deviations are equal or free for all clusters.}
}

check if a vector of kernel mixture model (KMM) name is correct.

check if a vector of kernel name is correct.
}
\details{
The model names are summarized in the following array:
\tabular{lll}{
 Model Name  \tab Proportions   \tab s. d. between clusters \cr
 kmm_p_sk    \tab equal         \tab Free                   \cr
 kmm_p_s     \tab equal         \tab Equal                  \cr
 kmm_pk_sk   \tab equal         \tab Free                   \cr
 kmm_pk_s    \tab equal         \tab Equal                  \cr
}
}
\examples{
kmmNames()
## same as c("kmm_p_sk")
kmmNames( prop = "equal", sdBetweenCluster= "free")

}
