% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_functions.R
\name{tax_datatable}
\alias{tax_datatable}
\title{Make a datatable with the taxonomy of a \code{\link{phyloseq-class}} object}
\usage{
tax_datatable(
  physeq,
  abundance = TRUE,
  taxonomic_level = NULL,
  modality = NULL,
  ...
)
}
\arguments{
\item{physeq}{(required): a \code{\link{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{abundance}{(default: TRUE) Does the number of sequences is print}

\item{taxonomic_level}{(default: NULL) a vector of selected taxonomic
level using their column numbers (e.g. taxonomic_level = 1:7)}

\item{modality}{(default: NULL) A sample modality to split
OTU abundancy by level of the modality}

\item{...}{Other argument for the datatable function}
}
\value{
A datatable
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}
}
\examples{
\dontshow{if (tolower(Sys.info()[["sysname"]]) != "windows") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data("GlobalPatterns", package = "phyloseq")
if (requireNamespace("DT")) {
  tax_datatable(subset_taxa(
    GlobalPatterns,
    rowSums(GlobalPatterns@otu_table) > 10000
  ))

  # Using modality
  tax_datatable(GlobalPatterns,
    modality = GlobalPatterns@sam_data$SampleType
  )
}
\dontshow{\}) # examplesIf}
}
\author{
Adrien Taudière
}
