% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellanous.R
\name{dist_bycol}
\alias{dist_bycol}
\title{Compute paired distances among matrix (e.g. otu_table)}
\usage{
dist_bycol(x, y, method = "bray", nperm = 99, ...)
}
\arguments{
\item{x}{(required) A first matrix.}

\item{y}{(required) A second matrix.}

\item{method}{(default: 'bray') the method to use internally in the vegdist
function.}

\item{nperm}{(int) The number of permutations to perform.}

\item{...}{Others argument for \code{vegan::vegdist} function}
}
\value{
A list of length two : (i) a vector of observed distance ($obs) and
(ii) a matrix of the distance after randomization ($null)
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


May be used to verify ecological distance among samples.
}
\note{
the first column of the first matrix is compare to the first column of
the second matrix, the second column of the first matrix is compare to the
second column of the second matrix and so on.
}
\seealso{
\code{\link[vegan]{vegdist}}
}
\author{
Adrien Taudière
}
