% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mosquito_BQ.R
\name{setup_mosquito_BQ}
\alias{setup_mosquito_BQ}
\title{Setup blood feeding & oviposition (BQ) behavioral state mosquito model}
\usage{
setup_mosquito_BQ(
  model,
  stochastic,
  eip,
  pB,
  pQ,
  psiQ,
  Psi_bb,
  Psi_bq,
  Psi_qb,
  Psi_qq,
  nu = 25,
  M,
  Y
)
}
\arguments{
\item{model}{an object from \link{make_MicroMoB}}

\item{stochastic}{should the model update deterministically or stochastically?}

\item{eip}{the Extrinsic Incubation Period (may be time varying see \link{time_varying_parameter})}

\item{pB}{daily survival probability during blood feeding (may be time and patch varying see \link{time_patch_varying_parameter})}

\item{pQ}{daily survival probability during oviposition (may be time and patch varying see \link{time_patch_varying_parameter})}

\item{psiQ}{oviposition success probability (may be time and patch varying see \link{time_patch_varying_parameter})}

\item{Psi_bb}{movement matrix from blood feeding haunts to blood feeding haunts (columns must sum to 1, \code{p} rows and columns)}

\item{Psi_bq}{movement matrix from blood feeding haunts to aquatic habitats (columns must sum to 1, \code{l} rows and \code{p} columns)}

\item{Psi_qb}{movement matrix from aquatic habitats to blood feeding haunts (columns must sum to 1, \code{p} rows and \code{l} columns)}

\item{Psi_qq}{movement matrix from aquatic habitats to aquatic habitats (columns must sum to 1, \code{l} rows and columns)}

\item{nu}{number of eggs laid per oviposition}

\item{M}{number of susceptible mosquitoes (vector of length \code{p + l})}

\item{Y}{number of incubating mosquitoes (matrix with \code{p + l} rows and \code{maxEIP + 1} columns)}
}
\value{
no return value
}
\description{
This is a behavioral state model which allows for time varying EIP and
survival probability. Mosquitoes transition between blood feeding (B) and
oviposition (Q) depending on the success (or not) of those biological activities.
It complies with the mosquito component interface, and may be simulated deterministically or stochastically.
}
