% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiRKAT_iQ.R
\name{MiRKAT.iQ}
\alias{MiRKAT.iQ}
\title{MiRKAT-iQ}
\usage{
MiRKAT.iQ(Y, X, K, weight = c(0.25, 0.25, 0.25, 0.25))
}
\arguments{
\item{Y}{A numeric vector of the continuous outcome variable.}

\item{X}{A numeric matrix for additional covariates that you want to adjust for.}

\item{K}{A list of n by n kernel matrices at a single n by n kernel matrix, where n is the sample size.}

\item{weight}{A length 4 vector specifying the weight for Cauchy combination, corresponding to wilcoxon/normal/inverselehmann/lehmann functions. The sum of the weight should be 1.}
}
\value{
Returns a list containing the p values for single kernels, or the omnibus p-value if multiple candidate kernel matrices are provided.
}
\description{
Integrated quantile regression-based kernel association test.
}
\examples{

library(GUniFrac)
library(quantreg)
library(PearsonDS)
library(MiRKAT)

data(throat.tree)
data(throat.otu.tab)

## Create UniFrac and Bray-Curtis distance matrices 
unifracs = GUniFrac(throat.otu.tab, throat.tree, alpha = c(1))$unifracs
if (requireNamespace("vegan")) {
 library(vegan)
 BC= as.matrix(vegdist(throat.otu.tab, method="bray"))
 Ds = list(w = unifracs[,,"d_1"], uw = unifracs[,,"d_UW"], BC = BC)
} else {
 Ds = list(w = unifracs[,,"d_1"], uw = unifracs[,,"d_UW"])
}

## Convert to kernels           
Ks = lapply(Ds, FUN = function(d) D2K(d))
covar = cbind(throat.meta$Age, as.numeric(throat.meta$Sex == "Male"))
n = nrow(throat.meta)
y = rnorm(n)
result = MiRKAT.iQ(y, X = covar, K = Ks)

}
\references{
Wang T, et al. (2021) Testing microbiome association using integrated quantile regression models. Bioinformatics (to appear).
}
\author{
Tianying Wang, Xiang Zhan.
}
