% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KRV_helper.R
\name{inner.KRV}
\alias{inner.KRV}
\title{Kernel RV Coefficient Test; Inner Function}
\usage{
inner.KRV(
  y = NULL,
  X = NULL,
  kernel.otu,
  kernel.y,
  returnKRV = FALSE,
  returnR2 = FALSE
)
}
\arguments{
\item{y}{A numeric n by p matrix of p continuous phenotype variables and sample size n (default = NULL). If y is NULL, a 
phenotype kernel matrix must be entered for "kernel.y". Defaults to NULL.}

\item{X}{A numeric n by q matrix, containing q additional covariates (default = NULL). If NULL, an intercept only model was fit. 
No covariate adjustment is possible if a matrix is provided for kernel.y.}

\item{kernel.otu}{A numeric n by n kernel matrix, where n is sample size. It can be constructed from microbiome data, such as
by transforming from a distance metric.}

\item{kernel.y}{Either a numeric n by n kernel matrix of phenotype or a method to compute the kernel of phenotype. Gaussian
kernel (kernel.y="Gaussian") can capture general relationship between microbiome and phenotypes; and linear kernel 
(kernel.y="linear") can be preferred if the underlying relationship is close to linear.}

\item{returnKRV}{A logical indicating whether to return the KRV statistic. Defaults to FALSE.}

\item{returnR2}{A logical indicating whether to return the R-squared coefficient. Defaults to FALSE.}
}
\value{
Returns a p-value for the candidate kernel matrix
    \item{pv}{p-value for the candidate kernel matrix}
    \item{KRV}{KRV statistic for the candidate kernel matrix. Only returned if returnKRV = TRUE.}  
    \item{R2}{R-squared for the candidate kernel matrix. Only returned if returnR2 = TRUE.}
}
\description{
Function called when user calls function KRV. For each kernel matrix inputted into KRV, KRV runs inner.KRV on that 
kernel with the inputted kernel.y outcome matrix.
}
\details{
y and X (if not NULL) should all be numerical matrices or vectors with the same number of rows.

 Ks should be a list of n by n matrices or a single matrix. If you have distance metric from metagenomic data, each kernel can be
 constructed through function D2K. Each kernel can also be constructed through other mathematical approaches.

 Missing data is not permitted. Please remove all individuals with missing y, X, Ks prior to analysis
 
Parameter "method" only concerns how kernel specific p-values are generated. When Ks is a list of multiple kernels, omnibus
p-value is computed through permutation from each individual p-value, which are calculated through method of choice.
}
\references{
Zhan, X., Plantinga, A., Zhao, N., and Wu, M.C. A Fast Small-Sample Kernel Independence Test for Microbiome Community-Level 
Association Analysis. Biometrics. 2017 Mar 10. doi: 10.1111/biom.12684.
}
\author{
Haotian Zheng, Xiang Zhan, Ni Zhao
}
