% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deviance.R
\name{deviance_bernoulli}
\alias{deviance_bernoulli}
\title{Bernoulli Deviance}
\usage{
deviance_bernoulli(actual, predicted, w = NULL, ...)
}
\arguments{
\item{actual}{Observed values (0 or 1).}

\item{predicted}{Predicted values strictly between 0 and 1.}

\item{w}{Optional case weights.}

\item{...}{Further arguments passed to \code{logLoss()}.}
}
\value{
A numeric vector of length one.
}
\description{
Calculates weighted average of unit Bernoulli deviance.
Defined as twice log loss. The smaller the deviance, the better.
}
\examples{
deviance_bernoulli(c(0, 0, 1, 1), c(0.1, 0.1, 0.9, 0.8))
deviance_bernoulli(c(0, 0, 1, 1), c(0.1, 0.1, 0.9, 0.8), w = 1:4)
}
\seealso{
\code{\link{logLoss}}.
}
