% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deviance_normal.R
\name{deviance_normal}
\alias{deviance_normal}
\title{Normal Deviance}
\usage{
deviance_normal(actual, predicted, w = NULL, ...)
}
\arguments{
\item{actual}{Observed values.}

\item{predicted}{Predicted values.}

\item{w}{Optional case weights.}

\item{...}{Further arguments passed to \code{mse}.}
}
\value{
A numeric vector of length one.
}
\description{
Weighted average of (unscaled) unit normal deviance. This equals the weighted mean-squared error, see e.g. the reference below. The smaller the deviance, the better.
}
\examples{
deviance_normal(1:10, c(1:9, 12))
deviance_normal(1:10, c(1:9, 12), w = rep(1, 10))
deviance_tweedie(1:10, c(1:9, 12), tweedie_p = 0)
deviance_normal(1:10, c(1:9, 12), w = 1:10)
}
\references{
Jorgensen, B. (1997). The Theory of Dispersion Models. Chapman & Hall/CRC. ISBN 978-0412997112.
}
\seealso{
\code{\link{deviance_tweedie}, \link{mse}}.
}
