% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassificationCV.R
\name{ClassificationCV}
\alias{ClassificationCV}
\title{ClassificationCV.}
\usage{
ClassificationCV(d = NULL, g = NULL, n = 1, k = 1, rand = F,
  method = c("svm", "C50", "rpart", "ropls")[1],
  method.control = list(), silent = FALSE)
}
\arguments{
\item{d}{Data matrix or data.frame with named rows (samples) and columns (traits).}

\item{g}{Group-vector, factor.}

\item{n}{Replicates of classifications.}

\item{k}{Number of folds per replicate.}

\item{rand}{Randomize Group-vector (and apply according n and k to this randomization).}

\item{method}{Currently \code{svm}, \code{ropls} and decison tree methods \code{C50} and \code{rpart} are supported.}

\item{method.control}{A list of parameters, forwarded to the respective classification function.}

\item{silent}{Logical. Set TRUE to supress progress bar and warnings.}
}
\value{
A list of classification results which can be analyzed for accuracy, missclassified samples etc.
}
\description{
\code{ClassificationCV} will perform a classification using SVM's and/or Decision Trees including cross validation on a data set according to a provided grouping vector.
}
\details{
This function allows to demonstrate the functionality of different classification tools with respect to building classfier for metabolomics data.
}
\examples{
# check the examples in \\code{\\link{ClassificationWrapper}} for automatic multifold analysis

}
