% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{tau_CI}
\alias{tau_CI}
\title{Return confidence interval for tau for a meta-analysis}
\usage{
tau_CI(meta, CI.level = 0.95)
}
\arguments{
\item{meta}{A meta-analysis object fit in \code{metafor::rma}.}

\item{CI.level}{Confidence interval level as a proportion (e.g., 0.95)}
}
\description{
Returns confidence interval lower and upper limits for tau (the estimated standard deviation of
the true effects) for a meta-analysis fit in \code{metafor::rma}.
}
\examples{
# calculate effect sizes for example dataset
d = metafor::escalc(measure="RR", ai=tpos, bi=tneg,
                   ci=cpos, di=cneg, data=metafor::dat.bcg)

# fit random-effects model
# note that metafor package returns on the log scale
m = metafor::rma.uni(yi= d$yi, vi=d$vi, knha=TRUE,
measure="RR", method="REML" )

tau_CI(m)

# for nicer formatting
format_CI( tau_CI(m)[1], tau_CI(m)[2] )
}
