% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trainClassifier.R
\name{trainClassifier}
\alias{trainClassifier}
\title{Train MetaClean Classifier}
\usage{
trainClassifier(trainData, model, metricSet, hyperparameters)
}
\arguments{
\item{trainData}{dataframe. Rows should correspond to peaks, columns should include peak quality metrics and class labels only.}

\item{model}{Name of the classification algorithm to be trained from the eight available:
DecisionTree, LogisiticRegression, NaiveBayes, RandomForest, SVM_Linear, AdaBoost, NeuralNetwork, and
ModelAveragedNeuralNetwork.}

\item{metricSet}{The metric set to be run with the selected model. Select from the following: M4, M7, and M11.}

\item{hyperparameters}{dataframe of the tuned hyperparameters returned by runCrossValidation()}
}
\value{
a trained MetaClean model
}
\description{
Wrapper function for training one of the 8 classification algorithms using one of the three available metrics sets.
}
\examples{
# train classification algorithms
\donttest{best_model <- trainClassifier(trainData=pqMetrics_development,
                                        model="AdaBoost",
                                        metricSet="M11",
                                        hyperparameters)}

}
