% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_data_methods.R
\name{createPlottingData}
\alias{createPlottingData}
\alias{createPlottingData,MetAlyzer-method}
\title{Create plotting data}
\usage{
createPlottingData(
  object,
  ...,
  ungrouped = NULL,
  ts = c(0.1, 0.2, 0.3),
  valid_vec = c("Valid", "LOQ"),
  t = 0.5
)

\S4method{createPlottingData}{MetAlyzer}(
  object,
  ...,
  ungrouped = NULL,
  ts = c(0.1, 0.2, 0.3),
  valid_vec = c("Valid", "LOQ"),
  t = 0.5
)
}
\arguments{
\item{object}{MetAlyzer object}

\item{...}{A selection of columns from meta_data to add to reshaped data frame}

\item{ungrouped}{A column from meta_data to add to reshaped data frame that
will not be used as grouping variables}

\item{ts}{A numeric vector of thresholds between 0 and 1 for CV categorization}

\item{valid_vec}{A character vector containing each quantification status that
is considered to be a valid measurement}

\item{t}{A numeric threshold to determine valid measurements}
}
\value{
An updated MetAlyzer object
}
\description{
This method reshapes raw_data, quant_status and meta_data and combines them
together with basic statistics in a tibble data frame for plotting with
ggplot2. plotting_data is grouped by metabolites as well as the selection of
additional variables. Statistics are then calculated for each group.
}
\section{Methods (by class)}{
\itemize{
\item \code{MetAlyzer}: Create plotting data
}}

\examples{
\donttest{
fpath <- system.file("extdata", "example_data.xlsx", package = "MetAlyzer")
obj <- MetAlyzerDataset(file_path = fpath)

obj <- createPlottingData(obj, Tissue, Group,
ungrouped = NULL,
ts = c(0.1, 0.2, 0.3),
valid_vec = c("Valid", "LOQ"), t = 0.5)
}
}
