% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remeshing.R
\name{isotropicRemesh}
\alias{isotropicRemesh}
\title{Isotropic remeshing}
\usage{
isotropicRemesh(
  vertices,
  faces,
  mesh = NULL,
  targetEdgeLength,
  iterations = 1,
  relaxSteps = 1,
  normals = FALSE
)
}
\arguments{
\item{vertices}{a numeric matrix with three columns}

\item{faces}{either an integer matrix (each row provides the vertex indices
of the corresponding face) or a list of integer vectors, each one
providing the vertex indices of the corresponding face}

\item{mesh}{if not \code{NULL}, this argument takes precedence over \code{vertices}
and \code{faces}, and must be either a list containing the fields \code{vertices}
and \code{faces} (objects as described above), otherwise a \strong{rgl} mesh
(i.e. a \code{mesh3d} object)}

\item{targetEdgeLength}{positive number, the target edge length of the
remeshed mesh}

\item{iterations}{number of iterations, a positive integer}

\item{relaxSteps}{number of relaxation steps, a positive integer}

\item{normals}{Boolean, whether to compute the vertex normals of the
output mesh}
}
\value{
A triangle mesh represented as the output of the
  \code{\link{Mesh}} function.
}
\description{
Isotropically remesh a mesh.
}
\examples{
library(MeshesOperations)
library(rgl)

theta <- seq(0, 2*pi, length.out = 16)
torus <- cylinder3d(
  cbind(cos(theta), sin(theta), 0),
  radius = 0.4, closed = TRUE
)

mesh <- isotropicRemesh(
  mesh = torus,
  targetEdgeLength = 0.3,
  iterations = 3
)
rglmesh <- toRGL(mesh)

open3d(windowRect = c(50, 50, 950, 500))
mfrow3d(1, 2)
view3d(0, 0, zoom = 0.8)
wire3d(torus)
next3d()
view3d(0, 0, zoom = 0.8)
wire3d(rglmesh)
}
