% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mega2famskatrc.R
\name{init_famSKATRC}
\alias{init_famSKATRC}
\title{load Mega2 SQLite database and perform initialization for famSKATRC usage}
\usage{
init_famSKATRC(db = NULL, verbose = FALSE, ALPHA = FALSE, ...)
}
\arguments{
\item{db}{specifies the path of a \bold{Mega2} SQLite database containing study data.}

\item{verbose}{TRUE indicates that diagnostic printouts should be enabled.
This value is saved in the returned environment.}

\item{ALPHA}{TRUE indicates that two runs of famSKAT_RC  should be enabled.
One with ALPHA numeric ID's and one with numeric IDs ... this is temporary.
The default is FALSE.}

\item{...}{fed to \emph{dbmega2_import()}; should be bpPosMap= to select from the maps of
base pairs, if the default is not desired.}
}
\value{
"environment" containing data frames from an SQLite database and some computed values.
}
\description{
This populates the \bold{R} data frames with the specified \bold{Mega2} SQLite database.  It initializes
 the fam(ily) table and makes sure the person entries are unique.  Finally, it generates a kinship matrix
 from the family data.  It also stores a weighting for the common and rare variant that may be used
 later if NULL is specified as a weight in \emph{Mega2famSKATRC}.  The common weighting is the function
 \emph{dbeta}(maf, 1, 25).  The rare weighting is the function \emph{dbeta}(maf, 0.5, 0.5).
}
\note{
\emph{init_famSKATRC} creates a new data frame, \emph{envir$phe}, containing phenotype observations.
 In addition, it initializes a matrix to aid
 in translating a genotype allele matrix to a genotype count matrix.

 It also initializes the data frame \emph{envir$famSKATRC_results} to zero rows.
}
\examples{
db = system.file("exdata", "seqsimm.db", package="Mega2R")
ENV = init_famSKATRC(db, verbose = FALSE)
ls(ENV)

}
\seealso{
\code{\link{Mega2famSKATRC}}
}
