% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{sort_sparse_indices}
\alias{sort_sparse_indices}
\title{Sort the indices of a sparse matrix or sparse vector}
\usage{
sort_sparse_indices(X, copy = FALSE, byrow = TRUE)
}
\arguments{
\item{X}{A sparse matrix in CSR, CSC, or COO format; or a sparse vector
(from the `Matrix` package.)}

\item{copy}{Whether to make a deep copy of the indices and the values before sorting
them, so that the in-place modifications will not affect any potential external
references to the same arrays.}

\item{byrow}{When passing a COO matrix ("TsparseMatrix"), whether to sort it
with rows as the major axis, which differs from `Matrix` that usually
sorts them with columns as the major axis.}
}
\value{
The same input `X` with its indices sorted, as invisible (no auto print).
Note that the input is itself modified, so there is no need to reassign it.
}
\description{
Will sort the indices of a sparse matrix or sparse vector.

In general, the indices of sparse CSR and CSC matrices are always meant to be sorted, and
it should be rare to have a matrix with unsorted indices when the matrix is the
output of some built-in operation from either `Matrix` or `MatrixExtra`, but when
the matrices are constructed manually this function can come in handy.

\bold{Important:} the input matrix will be modified in-place, unless passing
`copy=TRUE`.
}
