% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.R
\name{is.wimids}
\alias{is.wimids}
\title{Checks for the \code{wimids} Class}
\usage{
is.wimids(object)
}
\arguments{
\item{object}{This argument specifies the object that should be checked to see if is of the \code{wimids} class or not.}
}
\value{
This function returns a logical value indicating whether \code{object} is of the \code{wimids} class.
}
\description{
The \code{is.wimids()} function checks whether class of objects are \code{wimids} or not.
}
\details{
The class of objects are checked to be of the \code{wimids}.
}
\examples{
\donttest{
#Loading the 'dt.osa' dataset
data(dt.osa)

#Imputing missing data points in the'dt.osa' dataset
datasets <- mice(dt.osa, m = 5, maxit = 1,
                 method = c("", "", "mean", "", "polyreg", "logreg", "logreg"))

#Weighting the imputed datasets, 'datasets'
weighteddatasets <- weightitmice(KOA ~ SEX + AGE + SMK, datasets,
                                 approach = 'within', method = 'nearest')

#Checking the 'weighteddatasets' object
is.wimids(weighteddatasets)
is(weighteddatasets)
}
}
\seealso{
\code{\link[=weightitmice]{weightitmice}}

\code{\link[=wimids]{wimids}}
}
\author{
Farhad Pishgar
}
\keyword{function}
