% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MapperAlgo.R
\name{MapperAlgo}
\alias{MapperAlgo}
\title{Mapper Algorithm}
\usage{
MapperAlgo(
  filter_values,
  intervals,
  percent_overlap,
  methods,
  method_params = list(),
  cover_type = "extension",
  num_cores = 1
)
}
\arguments{
\item{filter_values}{A data frame or matrix of the data to be analyzed.}

\item{intervals}{An integer specifying the number of intervals.}

\item{percent_overlap}{Percentage of overlap between consecutive intervals.}

\item{methods}{Specify the clustering method to be used, e.g., "hclust" or "kmeans".}

\item{method_params}{A list of parameters for the clustering method.}

\item{cover_type}{Type of interval, either 'stride' or 'extension'.}

\item{num_cores}{Number of cores to use for parallel computing.}
}
\value{
A list containing the Mapper graph components:
\describe{
\item{adjacency}{The adjacency matrix of the Mapper graph.}
\item{num_vertices}{The number of vertices in the Mapper graph.}
\item{level_of_vertex}{A vector specifying the level of each vertex.}
\item{points_in_vertex}{A list of the indices of the points in each vertex.}
\item{points_in_level_set}{A list of the indices of the points in each level set.}
\item{vertices_in_level_set}{A list of the indices of the vertices in each level set.}
}
}
\description{
Implements the Mapper algorithm for Topological Data Analysis (TDA).
It divides data into intervals, applies clustering within each interval, and constructs a
simplicial complex representing the structure of the data.
}
