% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manifolds.R
\name{Manifold definitions}
\alias{Manifold definitions}
\alias{get.stiefel.defn}
\alias{get.grassmann.defn}
\alias{get.spd.defn}
\alias{get.sphere.defn}
\alias{get.euclidean.defn}
\alias{get.lowrank.defn}
\alias{get.orthgroup.defn}
\title{Manifold definitions}
\usage{
get.stiefel.defn(n, p, numofmani = 1L, ParamSet = 1L)

get.grassmann.defn(n, p, numofmani = 1L, ParamSet = 1L)

get.spd.defn(n, numofmani = 1L, ParamSet = 1L)

get.sphere.defn(n, numofmani = 1L, ParamSet = 1L)

get.euclidean.defn(n, m, numofmani = 1L, ParamSet = 1L)

get.lowrank.defn(n, m, p, numofmani = 1L, ParamSet = 1L)

get.orthgroup.defn(n, numofmani = 1L, ParamSet = 1L)
}
\arguments{
\item{n}{Dimension for manifold object (see Details)}

\item{p}{Dimension for manifold object (see Details)}

\item{numofmani}{Multiplicity of this space. For example, use
\code{numofmani = 2} if problem requires 2 points from this manifold}

\item{ParamSet}{A positive integer indicating a set of properties for the
manifold which can be used by the solver. See Huang et al (2016b)
for details.}

\item{m}{Dimension for manifold object (see Details)}
}
\value{
List containing input arguments and name field denoting the type of manifold
}
\description{
Get definitions for simple manifolds
}
\details{
The functions define manifolds as follows:
\itemize{
\item{\code{get.stiefel.defn}}: Stiefel manifold
   \eqn{\{X \in R^{n \times p} : X^T X = I\}}
\item{\code{get.grassmann.defn}}: Grassmann manifold of \eqn{p}-dimensional
  subspaces in \eqn{R^n}
\item{\code{get.spd.defn}}: Manifold of \eqn{n \times n} symmetric positive
   definite matrices
\item{\code{get.sphere.defn}}: Manifold of \eqn{n}-dimensional vectors on
   the unit sphere
\item{\code{get.euclidean.defn}}: Euclidean \eqn{R^{n \times m}} space
\item{\code{get.lowrank.defn}}: Low-rank manifold
   \eqn{\{ X \in R^{n \times m} : \textrm{rank}(X) = p \}}
\item{\code{get.orthgroup.defn}}: Orthonormal group
   \eqn{\{X \in R^{n \times n} : X^T X = I\}}
}
}
\references{
Wen Huang, P.A. Absil, K.A. Gallivan, Paul Hand (2016a). "ROPTLIB: an
object-oriented C++ library for optimization on Riemannian manifolds."
Technical Report FSU16-14, Florida State University.

Wen Huang, Kyle A. Gallivan, and P.A. Absil (2016b).
Riemannian Manifold Optimization Library.
URL \url{http://www.math.fsu.edu/~whuang2/pdf/USER_MANUAL_for_2016-04-29.pdf}

S. Martin, A. Raim, W. Huang, and K. Adragni (2020). "ManifoldOptim: 
An R Interface to the ROPTLIB Library for Riemannian Manifold Optimization."
Journal of Statistical Software, 93(1):1-32.
}
