% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/em-magma.R
\name{m_step}
\alias{m_step}
\title{M-Step of the EM algorithm}
\usage{
m_step(
  db,
  m_0,
  kern_0,
  kern_i,
  old_hp_0,
  old_hp_i,
  post_mean,
  post_cov,
  common_hp,
  pen_diag
)
}
\arguments{
\item{db}{A tibble or data frame. Columns required: ID, Input, Output.
Additional columns for covariates can be specified.}

\item{m_0}{A vector, corresponding to the prior mean of the mean GP.}

\item{kern_0}{A kernel function, associated with the mean GP.}

\item{kern_i}{A kernel function, associated with the individual GPs.}

\item{old_hp_0}{A named vector, tibble or data frame, containing the
hyper-parameters from the previous M-step (or initialisation) associated
with the mean GP.}

\item{old_hp_i}{A tibble or data frame, containing the hyper-parameters
from the previous M-step (or initialisation) associated with the
individual GPs.}

\item{post_mean}{A tibble, coming out of the E step, containing the Input and
associated Output of the hyper-posterior mean parameter.}

\item{post_cov}{A matrix, coming out of the E step, being the hyper-posterior
covariance parameter.}

\item{common_hp}{A logical value, indicating whether the set of
hyper-parameters is assumed to be common to all indiviuals.}

\item{pen_diag}{A number. A jitter term, added on the diagonal to prevent
numerical issues when inverting nearly singular matrices.}
}
\value{
A named list, containing the elements \code{hp_0}, a tibble
containing the hyper-parameters associated with the mean GP,
\code{hp_i}, a tibble containing the hyper-parameters
associated with the individual GPs.
}
\description{
Maximisation step of the EM algorithm to compute hyper-parameters of all the
kernels involved in Magma.
}
\examples{
TRUE
}
