% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihoods.R
\name{logL_GP_mod}
\alias{logL_GP_mod}
\title{Modified log-Likelihood function for GPs}
\usage{
logL_GP_mod(hp, db, mean, kern, post_cov, pen_diag)
}
\arguments{
\item{hp}{A tibble, data frame or named vector of hyper-parameters.}

\item{db}{A tibble containing values we want to compute logL on.
Required columns: Input, Output. Additional covariate columns are allowed.}

\item{mean}{A vector, specifying the mean of the GP at the reference inputs.}

\item{kern}{A kernel function.}

\item{post_cov}{A matrix, covariance parameter of the hyper-posterior.
Used to compute the correction term.}

\item{pen_diag}{A jitter term that is added to the covariance matrix to avoid
numerical issues when inverting, in cases of nearly singular matrices.}
}
\value{
A number, corresponding to the value of the modified Gaussian
log-Likelihood defined in Magma.
}
\description{
Log-Likelihood function involved in Magma during the maximisation step of
the training. The log-Likelihood is defined as a simple Gaussian likelihood
added with correction trace term.
}
\examples{
TRUE
}
