% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_curve.R
\name{lift}
\alias{lift}
\title{Model Lift Curves}
\usage{
lift(x, y = NULL, na.rm = TRUE, ...)
}
\arguments{
\item{x}{\link[=response]{observed responses} or \link{resample} result
containing observed and predicted responses.}

\item{y}{\link[=predict]{predicted responses} if not contained in \code{x}.}

\item{na.rm}{logical indicating whether to remove observed or predicted
responses that are \code{NA} when calculating metrics.}

\item{...}{arguments passed to other methods.}
}
\value{
\code{LiftCurve} class object that inherits from
\code{PerformanceCurve}.
}
\description{
Calculate lift curves from observed and predicted responses.
}
\examples{
library(MASS)

res <- resample(type ~ ., data = Pima.tr, model = GBMModel)
lf <- lift(res)
plot(lf)

}
\seealso{
\code{\link{c}}, \code{\link{plot}}, \code{\link{summary}}
}
