% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_TreeModel.R
\name{TreeModel}
\alias{TreeModel}
\title{Classification and Regression Tree Models}
\usage{
TreeModel(
  mincut = 5,
  minsize = 10,
  mindev = 0.01,
  split = c("deviance", "gini")
)
}
\arguments{
\item{mincut}{minimum number of observations to include in either child node.}

\item{minsize}{smallest allowed node size: a weighted quantity.}

\item{mindev}{within-node deviance must be at least this times that of the
root node for the node to be split.}

\item{split}{splitting criterion to use.}
}
\value{
\code{MLModel} class object.
}
\description{
A tree is grown by binary recursive partitioning using the response in the
specified formula and choosing splits from the terms of the right-hand-side.
}
\details{
\describe{
  \item{Response Types:}{\code{factor}, \code{numeric}}
}

Further model details can be found in the source link below.
}
\examples{
fit(Species ~ ., data = iris, model = TreeModel)

}
\seealso{
\code{\link[tree]{tree}}, \code{\link{fit}},
\code{\link{resample}}
}
