% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrainedRecipes.R
\name{SelectedRecipe}
\alias{SelectedRecipe}
\title{Selected Recipe}
\usage{
SelectedRecipe(
  ...,
  control = MachineShop::settings("control"),
  metrics = NULL,
  stat = MachineShop::settings("stat.Train"),
  cutoff = MachineShop::settings("cutoff")
)
}
\arguments{
\item{...}{untrained \code{\link[recipes:recipe]{recipes}} or a list of them.}

\item{control}{\link[=controls]{control} function, function name, or call
defining the resampling method to be employed.}

\item{metrics}{\link[=metrics]{metric} function, function name, or vector of
these with which to calculate performance.  If not specified, default
metrics defined in the \link{performance} functions are used.  Recipe
selection is based on the first calculated metric.}

\item{stat}{function or character string naming a function to compute a
summary statistic on resampled metric values for recipe selection.}

\item{cutoff}{argument passed to the \code{metrics} functions.}
}
\value{
\code{SelectedRecipe} class object that inherits from \code{recipe}.
}
\description{
Recipe selection from a candidate set.
}
\examples{
library(recipes)
library(MASS)

rec1 <- recipe(medv ~ crim + zn + indus + chas + nox + rm, data = Boston)
rec2 <- recipe(medv ~ chas + nox + rm + age + dis + rad + tax, data = Boston)

fit(SelectedRecipe(rec1, rec2), model = GLMModel)

}
\seealso{
\code{\link{fit}}, \code{\link{resample}}
}
