% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_BARTModel.R
\name{BARTModel}
\alias{BARTModel}
\title{Bayesian Additive Regression Trees Model}
\usage{
BARTModel(K = NULL, sparse = FALSE, theta = 0, omega = 1,
  a = 0.5, b = 1, rho = NULL, augment = FALSE, xinfo = NULL,
  usequants = FALSE, sigest = NA, sigdf = 3, sigquant = 0.9,
  lambda = NA, k = 2, power = 2, base = 0.95, tau.num = NULL,
  offset = NULL, ntree = NULL, numcut = 100, ndpost = 1000,
  nskip = NULL, keepevery = NULL, printevery = 1000)
}
\arguments{
\item{K}{if provided, then coarsen the times of survival responses per the
quantiles \eqn{1/K, 2/K, ..., K/K} to reduce computational burdern.}

\item{sparse}{logical indicating whether to perform variable selection based
on a sparse Dirichlet prior rather than simply uniform; see Linero 2016.}

\item{theta, omega}{\eqn{theta} and \eqn{omega} parameters; zero means
random.}

\item{a, b}{sparse parameters for \eqn{Beta(a, b)} prior:
\eqn{0.5 <= a <= 1} where lower values induce more sparsity and typically
\eqn{b = 1}.}

\item{rho}{sparse parameter: typically \eqn{rho = p} where \eqn{p} is the
number of covariates under consideration.}

\item{augment}{whether data augmentation is to be performed in sparse
variable selection.}

\item{xinfo}{optional matrix whose rows are the covariates and columns their
cutpoints.}

\item{usequants}{whether covariate cutpoints are defined by uniform quantiles
or generated uniformly.}

\item{sigest}{normal error variance prior for numeric response variables.}

\item{sigdf}{degrees of freedom for error variance prior.}

\item{sigquant}{quantile at which a rough estimate of the error standard
deviation is placed.}

\item{lambda}{scale of the prior error variance.}

\item{k}{number of standard deviations \eqn{f(x)}  is away from +/-3 for
categorical response variables.}

\item{power, base}{power and base parameters for tree prior.}

\item{tau.num}{numerator in the \eqn{tau} definition, i.e.,
\eqn{tau = tau.num / (k * sqrt(ntree))}.}

\item{offset}{override for the default \eqn{offset} of \eqn{F^-1(mean(y))}
in the multivariate response probability
\eqn{P(y[j] = 1 | x) = F(f(x)[j] + offset[j])}.}

\item{ntree}{number of trees in the sum.}

\item{numcut}{number of possible covariate cutoff values.}

\item{ndpost}{number of posterior draws returned.}

\item{nskip}{number of MCMC iterations to be treated as burn in.}

\item{keepevery}{interval at which to keep posterior draws.}

\item{printevery}{interval at which to print MCMC progress.}
}
\value{
\code{MLModel} class object.
}
\description{
Flexible nonparametric modeling of covariates for continuous, binary,
categorical and time-to-event outcomes.
}
\details{
\describe{
  \item{Response Types:}{\code{factor}, \code{numeric}, \code{Surv}}
}

Default values for the \code{NULL} arguments and further model details can be
found in the source links below.
}
\examples{
\donttest{
fit(sale_amount ~ ., data = ICHomes, model = BARTModel)
}

}
\seealso{
\code{\link[BART]{gbart}}, \code{\link[BART]{mbart}},
\code{\link[BART]{surv.bart}}, \code{\link{fit}}, \code{\link{resample}},
\code{\link{tune}}
}
